import sys
import psycopg2
import configparser

def connect_to_warehouse():
    # Pobranie z pliku konfiguracyjnego parametrów połączenia z bazą danych.
    parser = configparser.ConfigParser()
    parser.read("pipeline.conf")
    dbname = parser.get("aws_creds", "database")
    user = parser.get("aws_creds", "username")
    password = parser.get("aws_creds", "password")
    host = parser.get("aws_creds", "host")
    port = parser.get("aws_creds", "port")

    # Nawiązanie połączenia z klastrem Redshift.
    rs_conn = psycopg2.connect("dbname=" + dbname + " user=" + user + " password=" + password + " host=" + host + " port=" + port)

    return rs_conn

# Przeprowadzenie testu składającego się
# z dwóch skryptów i operatora porównania.
# Wartością zwrotną jest true/false testu zaliczonego/niezaliczonego.
def execute_test(db_conn, script_1, script_2, comp_operator):

    # Wykonanie pierwszego skryptu i przechowywanie wyniku.
    cursor = db_conn.cursor()
    sql_file = open(script_1, 'r')
    cursor.execute(sql_file.read())

    record = cursor.fetchone()
    result_1 = record[0]
    db_conn.commit()
    cursor.close()

    # Wykonanie drugiego skryptu i przechowywanie wyniku.
    cursor = db_conn.cursor()
    sql_file = open(script_2, 'r')
    cursor.execute(sql_file.read())

    record = cursor.fetchone()
    result_2 = record[0]
    db_conn.commit()
    cursor.close()

    print("Wynik 1 = " + str(result_1))
    print("Wynik 2 = " + str(result_2))

    # Porównanie wartości na podstawie operatora comp_operator.
    if comp_operator == "equals":
        return result_1 == result_2
    elif comp_operator == "greater_equals":
        return result_1 >= result_2
    elif comp_operator == "greater":
        return result_1 > result_2
    elif comp_operator == "less_equals":
        return result_1 <= result_2
    elif comp_operator == "less":
        return result_1 < result_2
    elif comp_operator == "not_equal":
        return result_1 != result_2

    # Skoro ma być wykonane poniższe polecenie, to coś poszło źle.
    return False

# Wartością test_result powinna być True lub False.
def send_slack_notification(webhook_url, script_1, script_2, comp_operator, test_result):
    try:
        if test_result == True:
            message = "Test weryfikacyjny został zaliczony!: " + script_1 + " / " + script_2 + " / " + comp_operator
        else:
            message = "Test weryfikacyjny NIE ZOSTAŁ ZALICZONY!: " + script_1 + " / " + script_2 + " / " + comp_operator

        slack_data = {'text': message}
        response = requests.post(webhook_url,
            data=json.dumps(slack_data),
            headers={
                'Content-Type': 'application/json'
            })

        if response.status_code != 200:
            print(response)
            return False
    except Exception as e:
        print("Błąd podczas przekazywania powiadomienia Slacka.")
        print(str(e))
        return False

if __name__ == "__main__":

    if len(sys.argv) == 2 and sys.argv[1] == "-h":
        print("Użycie: python validator.py script1.sql script2.sql comparison_operator")
        print("Poprawnymi wartościami comparison_operator są:")
        print("equals")
        print("greater_equals")
        print("greater")
        print("less_equals")
        print("less")
        print("not_equal")

        exit(0)

    if len(sys.argv) != 5:
        print("Użycie: python validator.py script1.sql script2.sql comparison_operator severity_level")
        exit(-1)

    script_1 = sys.argv[1]
    script_2 = sys.argv[2]
    comp_operator = sys.argv[3]
    sev_level = sys.argv[4]

    # Nawiązanie połączenia z hurtownią danych.
    db_conn = connect_to_warehouse()

    # Przeprowadzenie testu weryfikacyjnego.
    test_result = execute_test(db_conn, script_1, script_2, comp_operator)


    print("Wynik testu: " + str(test_result))

    if test_result == True:
        exit(0)
    else:
        #send_slack_notification(webhook_url, script_1, script_2, comp_operator, test_result)
        if sev_level == "halt":
            exit(-1)
        else:
            exit(0)
